/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.crs;

import java.io.File;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.NodeRole;
import oracle.cluster.deployment.BigClusterException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.deployment.BigClusterImpl;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.cluster.ClusterConfig;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.SingleClusterNode;
import oracle.install.library.util.cvu.CVUHelper;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;

public class CRSInfo {
    private Logger logger = Logger.getLogger(CRSInfo.class.getName());
    private String crsVersion;
    private HashMap<String, NodeRole> activeRoleNodeMap = null;
    private HashMap<String, NodeRole> configRoleNodeMap = null;
    private static CRSInfo instance = null;
    private String localNodeName;
    public static final char sep = File.separatorChar;
    String clusterName;
    private ClusterwareInfo clusterwareInfo = null;
    public static final String OIFCFG_SUBDIR = "ext" + File.separator + "bin";
    Boolean isConfiguredGIHomePresent = null;
    private ClusterConfig clusterConfig;
    private String configuredCRSHome = null;
    private BigClusterImpl bigClusterImpl;

    public void initClusterwareInfo() {
        if (this.clusterwareInfo == null) {
            this.clusterwareInfo = new ClusterwareInfo();
        }
    }

    public static CRSInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (CRSInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(CRSInfo.class)) == null) {
            instance = new CRSInfo();
        }
        return instance;
    }

    public String getDefaultClusterName() {
        String strDefCRSName = this.getClusterPrefix();
        if (strDefCRSName.length() > 0) {
            strDefCRSName = strDefCRSName + "-";
        }
        return strDefCRSName + "cluster";
    }

    public String getClusterPrefix() {
        StringBuffer prefix = new StringBuffer("");
        MachineInfo mInfo = MachineInfo.getInstance();
        String hostWithoutDomain = mInfo.getLocalMachineName();
        if (hostWithoutDomain != null && hostWithoutDomain.trim().length() > 0) {
            prefix = new StringBuffer(hostWithoutDomain);
            String regEx = "[0-9]";
            boolean hasNumericSuffix = true;
            while (hasNumericSuffix && prefix.length() > 0) {
                String lastChar = prefix.substring(prefix.length() - 1);
                hasNumericSuffix = lastChar.matches(regEx);
                if (!hasNumericSuffix) continue;
                prefix.deleteCharAt(prefix.length() - 1);
            }
            if (prefix.length() > 7) {
                prefix = new StringBuffer(prefix.substring(0, 7));
            }
        }
        return prefix.toString();
    }

    public String getCRSHome() {
        if (this.configuredCRSHome == null || this.configuredCRSHome.length() == 0) {
            List<String> pre112CRSHomes = null;
            List<String> giHomes = null;
            String crsHome = "";
            InventoryInfo invInfo = InventoryInfo.getInstance();
            try {
                giHomes = invInfo.getListOfOH("oracle.crs", "11.2.0.0.0", "999.9.9.9.9");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (giHomes != null && giHomes.size() > 0) {
                ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                String home = giHomes.get(0);
                try {
                    crsHome = clusterwareInfo.getCRSHome(new oracle.ops.mgmt.cluster.Version());
                }
                catch (InstallException e) {
                    this.logger.log(Level.WARNING, "Failed to execute getcrshome", e.getMessage());
                }
                if (crsHome != null && crsHome.length() > 0) {
                    this.configuredCRSHome = crsHome;
                    return crsHome;
                }
            }
            try {
                pre112CRSHomes = invInfo.getListOfOH("oracle.crs", "10.1.0.0.0", "11.1.9.9.9");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (pre112CRSHomes != null && pre112CRSHomes.size() > 0) {
                crsHome = pre112CRSHomes.get(0);
            }
            this.configuredCRSHome = crsHome;
        }
        return this.configuredCRSHome;
    }

    public String getCRSNodeList() {
        String crsNodeList = "";
        try {
            InventoryInfo inv = InventoryInfo.getInstance();
            crsNodeList = inv.getCRSNodes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return crsNodeList;
    }

    public String[] getNodesFromCRSstack() {
        String[] clusterNodes = null;
        try {
            if (this.isCRSConfigured()) {
                if (this.isBigCluster()) {
                    this.initClusterNodeConfigRoles(this.getCRSHome());
                    if (this.configRoleNodeMap != null) {
                        String localNode = this.getLocalNodeName();
                        ArrayList<String> nodelist = new ArrayList<String>(this.configRoleNodeMap.keySet());
                        if (nodelist.indexOf(localNode) > 0) {
                            Collections.swap(nodelist, 0, nodelist.indexOf(localNode));
                        }
                        clusterNodes = nodelist.toArray(new String[0]);
                    }
                } else {
                    try {
                        clusterNodes = new ClusterInfo(this.getCRSHome()).getNodeNames();
                    }
                    catch (NoSuchCRSHomeException e) {
                        this.logger.log(Level.INFO, "NoSuchCRSHomeException while checking for node names from stack", e);
                    }
                    catch (NoSuchExecutableException e) {
                        this.logger.log(Level.INFO, "NoSuchCRSHomeException while checking for node names from stack", e);
                    }
                    catch (ClusterInfoException e) {
                        this.logger.log(Level.INFO, "NoSuchCRSHomeException while checking for node names from stack", e);
                    }
                }
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
        }
        return clusterNodes;
    }

    public String getCRSActiveVersion() {
        try {
            if (this.isCRSConfigured()) {
                try {
                    ClusterInfo cInfo = new ClusterInfo(this.getCRSHome());
                    return cInfo.getCRSActiveVersionString();
                }
                catch (ClusterInfoException e) {
                    return "";
                }
                catch (Exception e) {
                    return "";
                }
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
        }
        return "";
    }

    public String getCRSHomeName() {
        return "";
    }

    public String getClusterName() {
        try {
            if (this.clusterName == null && this.isCRSConfigured()) {
                ProcessBuilder processBuilder = new ProcessBuilder(this.getCRSHome() + sep + "bin" + sep + "cemutlo");
                processBuilder.command().add("-n");
                AbstractLineProcessor lineProcessor = new AbstractLineProcessor(){

                    public void processLine(String line, int lineNumber) {
                        CRSInfo.this.clusterName = line;
                    }
                };
                ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, (OutputProcessor)lineProcessor, null);
                try {
                    ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
                }
                catch (Exception e) {
                    this.logger.severe("GetClusterName Exception:" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.INFO, "Exception while detecting the crs is configured", e);
        }
        return this.clusterName;
    }

    public boolean isCRsActive() {
        return false;
    }

    public String[] getNetworkInterfaces() {
        String oifcfgPath = InstallHelper.getInstallBinariesPath();
        ArrayList<String> interfaceList = new ArrayList<String>();
        try {
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            List results = null;
            results = clusterwareInfo.listInterfaces(oifcfgPath, true);
            for (OIFCFGResult res : results) {
                String interfaceName = res.getInterfaceName();
                String subnet = res.getSubnet().getHostAddress();
                OifcfgMapping type = OifcfgMapping.valueOf(res.getInterfaceType().toUpperCase());
                String netmask = res.getSubnetMaskAsString();
                String interfaceStr = interfaceName + "/" + subnet + "/" + type.getValue() + "/" + netmask;
                interfaceList.add(interfaceStr);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Exception occurred while getting the interface list from the local node", e);
        }
        return interfaceList.toArray(new String[0]);
    }

    public String getDefaultNodeList() {
        return "";
    }

    public String getLocalNodeName() {
        try {
            if (this.localNodeName == null && this.isCRSConfigured()) {
                try {
                    ClusterInfo clusterInfo = new ClusterInfo(this.getCRSHome());
                    this.localNodeName = clusterInfo.getLocalNodeName();
                }
                catch (ClusterInfoException e) {
                    this.logger.log(Level.INFO, "Exception while getting the local node name from crs stack", e);
                }
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
        }
        return this.localNodeName;
    }

    public String getCRSVersion() {
        try {
            if (this.crsVersion == null && this.isCRSConfigured()) {
                try {
                    ClusterInfo clusterInfo = new ClusterInfo(this.getCRSHome());
                    this.crsVersion = clusterInfo.getCRSActiveVersionString();
                }
                catch (ClusterInfoException e) {
                    this.logger.log(Level.INFO, "Exception while getting the active version from crs stack", e);
                }
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
        }
        return this.crsVersion;
    }

    public List<String> getRemoteNodes() {
        ArrayList<String> nodeList = new ArrayList<String>();
        try {
            ClusterInfo clusterInfo;
            String[] nodeNames;
            if (this.getCRSHome() != null && (nodeNames = (clusterInfo = new ClusterInfo(this.getCRSHome())).getNodeNames()) != null && nodeNames.length > 0) {
                for (String node : nodeNames) {
                    if (node.equals(clusterInfo.getLocalNodeName())) continue;
                    nodeList.add(node);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nodeList;
    }

    public String getDefaultGNSDomain() {
        String gnsDomain = null;
        String prefix = this.getClusterPrefix();
        String domain = MachineInfo.getInstance().getDomainName();
        gnsDomain = prefix + "." + domain;
        return gnsDomain;
    }

    public String getDefaultIPAddressForGNSVIP() {
        String defaultIP;
        block12: {
            defaultIP = null;
            String scratchPath = System.getProperty("oracle.installer.scratchPath");
            String oifcfgPath = scratchPath + File.separator + OIFCFG_SUBDIR;
            NetworkInterface oInterface = null;
            List results = null;
            try {
                oInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(MachineInfo.getInstance().getFullHostName()));
            }
            catch (SocketException e) {
                this.logger.log(Level.INFO, "Exception occurred while getting the interface name of the local node");
            }
            catch (UnknownHostException e) {
                this.logger.log(Level.INFO, "Exception occurred while getting the interface name of the local node");
            }
            try {
                ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                results = clusterwareInfo.listInterfaces(MachineInfo.getInstance().getFullHostName(), oifcfgPath, true);
                if (oInterface != null && results != null && results.size() > 0) {
                    for (OIFCFGResult res : results) {
                        StringTokenizer tokenizer;
                        int numOfTokens;
                        if (!oInterface.getName().equals(res.getInterfaceName())) continue;
                        InetAddress subnet = res.getSubnet();
                        if (!(subnet instanceof Inet4Address) || (numOfTokens = (tokenizer = new StringTokenizer(defaultIP = subnet.getHostAddress(), ".")).countTokens()) != 4) break block12;
                        String[] tokens = new String[numOfTokens];
                        int tokenIndex = 0;
                        while (tokenizer.hasMoreElements()) {
                            tokens[tokenIndex++] = tokenizer.nextToken();
                        }
                        String lastField = tokens[numOfTokens - 1];
                        try {
                            int last = Integer.parseInt(lastField);
                            tokens[numOfTokens - 1] = Integer.toString(++last);
                        }
                        catch (NumberFormatException e) {
                            this.logger.log(Level.INFO, "Error while defaulting the GNS VIP");
                        }
                        defaultIP = "";
                        for (String s : tokens) {
                            defaultIP = defaultIP + s + ".";
                        }
                        defaultIP = defaultIP.substring(0, defaultIP.length() - 1);
                        break block12;
                    }
                    break block12;
                }
                if (oInterface == null) {
                    this.logger.log(Level.WARNING, "NetworkInterface object is null");
                }
            }
            catch (InstallException e) {
                this.logger.log(Level.WARNING, "The defaulting of GNS VIP failed.", e);
            }
        }
        return defaultIP;
    }

    public HashMap<String, String> getAdminGroups(String crsHome) {
        this.initClusterwareInfo();
        try {
            String osdbagrpUtilPath = new File(crsHome, "bin").getAbsolutePath();
            oracle.ops.mgmt.cluster.Version version = this.clusterwareInfo.getSRVCTLVersion(crsHome);
            HashMap groupOutput = this.clusterwareInfo.getAdminGroups(osdbagrpUtilPath, version);
            for (Map.Entry e : groupOutput.entrySet()) {
                groupOutput.put(e.getKey(), ((String)e.getValue()).replaceAll("[\\[\\]]", ""));
            }
            return groupOutput;
        }
        catch (InstallException e) {
            return null;
        }
    }

    public List<String> getHAManagedDatabases(String crsHomeLoc) {
        this.initClusterwareInfo();
        try {
            return this.clusterwareInfo.getHAManagedDatabases(crsHomeLoc);
        }
        catch (InstallException e) {
            return null;
        }
    }

    public boolean doesDatabaseExistsOnNode(String crsHoome, String node, String db) throws InstallException {
        this.initClusterwareInfo();
        return this.clusterwareInfo.isDatabaseExists(crsHoome, node, db);
    }

    public String getActualHostName(String node) {
        String hostname = "";
        oracle.ops.mgmt.cluster.Version version = new oracle.ops.mgmt.cluster.Version();
        try {
            hostname = ClusterInfo.getHostName((String)node, (oracle.ops.mgmt.cluster.Version)version);
        }
        catch (ClusterInfoException e) {
            this.logger.info("Failed while retrieving the hostname for the nodes");
        }
        return hostname;
    }

    public boolean isConfiguredGIHomePresent() {
        if (this.isConfiguredGIHomePresent == null) {
            this.isConfiguredGIHomePresent = new Boolean(false);
            ClusterwareInfo clusterInfo = new ClusterwareInfo();
            try {
                if (clusterInfo.isHAConfigured() || clusterInfo.isCRSConfigured()) {
                    Version version = InventoryInfo.getInstance().getProductVersion(this.getCRSHome());
                    this.isConfiguredGIHomePresent = version.compareTo(InstallConstants.VERSION_11_2, 4) >= 0 ? new Boolean(true) : new Boolean(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.isConfiguredGIHomePresent;
    }

    public Version getConfiguredHAVersion() {
        ClusterwareInfo clusterInfo = new ClusterwareInfo();
        try {
            if (clusterInfo.isHAConfigured()) {
                return InventoryInfo.getInstance().getProductVersion(this.getCRSHome());
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "failed while getting Configured HA Version");
        }
        return null;
    }

    public String getCRSUser() {
        try {
            CVUHelper cvu = CVUHelper.getInstance();
            VerificationResult result = cvu.getCRSUser();
            if (result != null) {
                return result.getActualValue();
            }
        }
        catch (VerificationException e) {
            this.logger.log(Level.WARNING, "Verification exception occured while getting crs user.");
        }
        catch (UnsupportedOperationException e) {
            this.logger.log(Level.WARNING, "Unsupported operation exception occured while getting crs user.");
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Exception occured while getting crs user.");
        }
        return null;
    }

    public String getSIHAUser() {
        try {
            CVUHelper cvu = CVUHelper.getInstance();
            VerificationResult result = cvu.getSIHAUser();
            if (result != null) {
                return result.getActualValue();
            }
        }
        catch (VerificationException e) {
            this.logger.log(Level.WARNING, "Verification exception occured while getting siha user.");
        }
        catch (UnsupportedOperationException e) {
            this.logger.log(Level.WARNING, "Unsupported operation exception occured while getting siha user.");
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Exception occured while getting siha user.");
        }
        return null;
    }

    public boolean isCRSRunningOnAnyNode(List<String> nodes) {
        try {
            if (this.isCRSConfigured()) {
                try {
                    String home = InventoryInfo.getInstance().getCRSHome();
                    return this.isCRSRunningOnAnyNode(home, nodes);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Exception occured while checking for crs on nodes. [" + nodes + "]");
                    this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
                }
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
        }
        return false;
    }

    public boolean isCRSRunningOnAnyNode(String crshome, List<String> nodes) {
        boolean crsRunning = false;
        boolean isPre112Home = true;
        Version version = InventoryInfo.getInstance().getProductVersion(crshome);
        if (version.compareTo(InstallConstants.VERSION_11_2, 4) >= 0) {
            isPre112Home = false;
        }
        for (String node : nodes) {
            try {
                crsRunning = isPre112Home ? ClusterInfo.checkCSSStatus((String)node, (String)crshome, (oracle.ops.mgmt.cluster.Version)new oracle.ops.mgmt.cluster.Version()) : new ClusterwareInfo().isCRSRunning(crshome, node);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Exception occurred while checking for crs running on node:" + node);
                this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
                crsRunning = false;
            }
            if (!crsRunning) continue;
            break;
        }
        return crsRunning;
    }

    public boolean isCRSRunningOnLocalNode() {
        try {
            if (this.isCRSConfigured()) {
                try {
                    String home = InventoryInfo.getInstance().getCRSHome();
                    return this.isCRSRunningOnLocalNode(home);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Exception occured while checking for crs on local node.");
                    this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
                }
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
        }
        return false;
    }

    public boolean isCRSRunningOnLocalNode(String crshome) {
        String strLocalHostName = MachineInfo.getInstance().getLocalMachineName();
        boolean crsRunning = false;
        boolean isPre112Home = true;
        Version version = InventoryInfo.getInstance().getProductVersion(crshome);
        if (version.compareTo(InstallConstants.VERSION_11_2, 4) >= 0) {
            isPre112Home = false;
        }
        try {
            crsRunning = isPre112Home ? ClusterInfo.checkCSSStatus((String)strLocalHostName, (String)crshome, (oracle.ops.mgmt.cluster.Version)new oracle.ops.mgmt.cluster.Version()) : new ClusterwareInfo().isCRSRunning(crshome, strLocalHostName);
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, "Exception occurred while checking for crs running on local node:[" + strLocalHostName + "]");
            this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
            crsRunning = false;
        }
        return crsRunning;
    }

    public boolean isASMRunning(String kfodPath) {
        String strLocalHostName = MachineInfo.getInstance().getLocalMachineName();
        return this.isASMRunning(kfodPath, strLocalHostName);
    }

    public boolean isASMRunning(String kfodPath, String node) {
        try {
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            return clusterwareInfo.isASMRunning(kfodPath, node);
        }
        catch (InstallException e) {
            this.logger.log(Level.WARNING, "Exception occurred while checking for ASM running on node:[" + node + "]:" + e.getMessage());
            return false;
        }
    }

    public VerificationResultSet checkCRSIntegrity(String[] nodes) {
        VerificationResultSet resultSet = null;
        if (DriverHelper.isCVUOperationEnabled((String)"oracle.install.cvu.checkCRSIntegrity")) {
            try {
                resultSet = CVUHelper.getInstance().checkCRSIntegrity(nodes);
            }
            catch (VerificationException e) {
                this.logger.log(Level.WARNING, "Error while checking CRS Integrity on given nodes");
                this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
            }
        }
        return resultSet;
    }

    public boolean isBigCluster() {
        this.initClusterwareInfo();
        boolean isBigCluster = false;
        try {
            if (this.clusterwareInfo.getCSSMode() == CSSMode.cssBCCLUSTERED) {
                isBigCluster = true;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Error while checking if it is a big cluster", e);
            isBigCluster = false;
        }
        return isBigCluster;
    }

    public int getMaxTargetHubSize() {
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        int maxHubSize = 0;
        try {
            maxHubSize = clusterwareInfo.getMaxHubSize();
        }
        catch (InstallException e) {
            this.logger.log(Level.WARNING, "Could not determine max hub size", e);
        }
        return maxHubSize;
    }

    public ClusterConfig getConfiguredCRSDetails(String oracleHome) {
        if (this.clusterConfig == null) {
            this.clusterConfig = new ClusterConfig();
            try {
                ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
                if (this.isBigCluster()) {
                    ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                    HashMap map = clusterwareInfo.getClusterNodeConfigRoles(oracleHome);
                    for (String key : map.keySet()) {
                        SingleClusterNode clusterNode = new SingleClusterNode(key, "");
                        if (map.get(key) == NodeRole.HUB) {
                            clusterNode.setNodeType(ClusterNode.NodeType.HUB);
                        } else if (map.get(key) == NodeRole.RIM) {
                            clusterNode.setNodeType(ClusterNode.NodeType.RIM);
                        } else if (map.get(key) == NodeRole.AUTO) {
                            clusterNode.setNodeType(ClusterNode.NodeType.AUTO);
                        }
                        clusterNodes.add(clusterNode);
                    }
                } else {
                    String[] nodes = this.getNodesFromCRSstack();
                    if (nodes != null && nodes.length > 0) {
                        for (String node : nodes) {
                            clusterNodes.add(new SingleClusterNode(node, ""));
                        }
                    }
                }
                this.clusterConfig.setClusterNodes(clusterNodes);
            }
            catch (InstallException e) {
                this.logger.log(Level.INFO, "Exception occurred while getting active node roles from cluster", e);
            }
        }
        return this.clusterConfig;
    }

    public NodeRole getConfiguredRole(String node) {
        if (this.isBigCluster()) {
            this.initClusterNodeConfigRoles(this.getCRSHome());
            if (this.configRoleNodeMap != null) {
                return this.configRoleNodeMap.get(node);
            }
        }
        return null;
    }

    public NodeRole getActiveRole(String node) {
        if (this.isBigCluster()) {
            this.initClusterNodeActiveRoles(this.getCRSHome());
            if (this.activeRoleNodeMap != null) {
                return this.activeRoleNodeMap.get(node);
            }
        }
        return null;
    }

    public List<String> getConfiguredHubNodes() {
        if (this.isBigCluster()) {
            return this.getNodelistForConfiguredRole(NodeRole.HUB);
        }
        return null;
    }

    public List<String> getConfiguredRimNodes() {
        if (this.isBigCluster()) {
            return this.getNodelistForConfiguredRole(NodeRole.RIM);
        }
        return null;
    }

    public List<String> getConfiguredAutoNodes() {
        if (this.isBigCluster()) {
            return this.getNodelistForConfiguredRole(NodeRole.AUTO);
        }
        return null;
    }

    public List<String> getActiveHubNodes() {
        if (this.isBigCluster()) {
            return this.getNodelistForActiveRole(NodeRole.HUB);
        }
        return null;
    }

    public List<String> getActiveRimNodes() {
        if (this.isBigCluster()) {
            return this.getNodelistForActiveRole(NodeRole.RIM);
        }
        return null;
    }

    private List<String> getNodelistForActiveRole(NodeRole role) {
        ArrayList<String> nodelist = null;
        this.initClusterNodeActiveRoles(this.getCRSHome());
        if (this.activeRoleNodeMap != null) {
            nodelist = new ArrayList<String>();
            for (Map.Entry<String, NodeRole> e : this.activeRoleNodeMap.entrySet()) {
                if (e.getValue() != role) continue;
                nodelist.add(e.getKey());
            }
        }
        return nodelist;
    }

    private List<String> getNodelistForConfiguredRole(NodeRole role) {
        ArrayList<String> nodelist = null;
        this.initClusterNodeConfigRoles(this.getCRSHome());
        if (this.configRoleNodeMap != null) {
            nodelist = new ArrayList<String>();
            for (Map.Entry<String, NodeRole> e : this.configRoleNodeMap.entrySet()) {
                if (e.getValue() != role) continue;
                nodelist.add(e.getKey());
            }
        }
        return nodelist;
    }

    private void initClusterNodeActiveRoles(String crsHome) {
        if (this.activeRoleNodeMap == null) {
            this.initClusterwareInfo();
            try {
                this.activeRoleNodeMap = this.clusterwareInfo.getClusterNodeActiveRoles(crsHome);
            }
            catch (InstallException e) {
                this.logger.log(Level.INFO, "Exception from getClusterNodeActiveRoles", e);
            }
        }
    }

    private void initClusterNodeConfigRoles(String crsHome) {
        if (this.configRoleNodeMap == null) {
            this.initClusterwareInfo();
            try {
                this.configRoleNodeMap = this.clusterwareInfo.getClusterNodeConfigRoles(crsHome);
            }
            catch (InstallException e) {
                this.logger.log(Level.INFO, "Exception from getClusterNodeActiveRoles", e);
            }
        }
    }

    public boolean isMgmtDBExists() {
        String crshome = this.getCRSHome();
        Version topLevelCompVersion = InventoryInfo.getInstance().getTopLevelCompVersion(crshome, "oracle.crs");
        boolean mgmtDBExists = false;
        if (topLevelCompVersion.compareTo(InstallConstants.VERSION_12_1) >= 0) {
            // empty if block
        }
        return mgmtDBExists;
    }

    public boolean isCRSConfigured() throws InstallException {
        this.initClusterwareInfo();
        boolean crsConfigured = false;
        crsConfigured = this.clusterwareInfo.isCRSConfigured();
        return crsConfigured;
    }

    public boolean isHAConfigured() throws InstallException {
        return this.clusterwareInfo.isHAConfigured();
    }

    public int getMgmtDBRequiredSize(int nodeCount, int seedSize) {
        this.initClusterwareInfo();
        int mgmtSpace = 0;
        try {
            mgmtSpace = this.clusterwareInfo.getMgmtDBSize(nodeCount, seedSize);
            this.logger.log(Level.FINEST, "Management db size =" + mgmtSpace);
        }
        catch (InstallException e) {
            this.logger.log(Level.INFO, "Error while calculating the required management DB size", e);
        }
        return mgmtSpace;
    }

    public int getMgmtDBRequiredSize(int hubOrAutoNodeCount, int rimNodeCount, int seedSize) {
        this.initClusterwareInfo();
        int mgmtSpace = 0;
        try {
            this.logger.log(Level.FINEST, "hub or Auto node count=" + hubOrAutoNodeCount + "rimNodeCount=" + rimNodeCount);
            mgmtSpace = this.clusterwareInfo.getMgmtDBSize(hubOrAutoNodeCount, rimNodeCount, seedSize);
            this.logger.log(Level.FINEST, "Management db size =" + mgmtSpace);
        }
        catch (InstallException e) {
            this.logger.log(Level.INFO, "Error while calculating the required management DB size", e);
        }
        return mgmtSpace;
    }

    public List<String> getNodesForAdminManagedDatabase(String crsHome) {
        ArrayList<String> nodelist = new ArrayList();
        this.bigClusterImpl = new BigClusterImpl();
        try {
            nodelist = this.bigClusterImpl.getNodesForAdminManagedDatabase(crsHome);
        }
        catch (BigClusterException e) {
            this.logger.log(Level.INFO, "Exception from getNodesForAdminManagedDatabase", e);
        }
        return nodelist;
    }

    private static enum OifcfgMapping {
        UNKNOWN(3),
        PRIVATE(2),
        PUBLIC(1);

        private String value;

        private OifcfgMapping(int indentifier) {
            this.value = indentifier + "";
        }

        public String getValue() {
            return this.value;
        }
    }
}

